// i18n translations for extension login page
const translations = {
  ru: {
    "login.title": "WB Calculator - Вход",
    "login.subtitle": "Войдите в свой аккаунт",
    "login.email": "Email",
    "login.emailPlaceholder": "your@email.com",
    "login.password": "Пароль",
    "login.passwordPlaceholder": "Введите пароль",
    "login.btn": "Войти",
    "login.btnLoading": "Вход...",
    "login.noAccount": "Нет аккаунта?",
    "login.register": "Зарегистрироваться",
    "login.secureConnection": "Защищённое соединение",
    "login.showPassword": "Показать пароль",
    "login.hidePassword": "Скрыть пароль",
    
    // Success/Error messages
    "login.success": "Вход выполнен успешно! Можете закрыть эту вкладку.",
    "login.errorEmpty": "Заполните все поля",
    "login.errorEmail": "Введите корректный email",
    "login.errorPasswordShort": "Пароль должен быть минимум 6 символов",
    "login.errorPasswordLong": "Пароль слишком длинный",
    "login.errorTimeout": "Превышено время ожидания. Проверьте соединение.",
    "login.errorGeneric": "Произошла ошибка",
    "login.errorRateLimit": "Слишком много попыток. Подождите {seconds} сек.",
    "login.errorServer": "Некорректный ответ сервера",
    "login.errorLogin": "Ошибка входа"
  },
  zh: {
    "login.title": "WB Calculator - 登录",
    "login.subtitle": "登录您的账户",
    "login.email": "电子邮件",
    "login.emailPlaceholder": "your@email.com",
    "login.password": "密码",
    "login.passwordPlaceholder": "输入密码",
    "login.btn": "登录",
    "login.btnLoading": "登录中...",
    "login.noAccount": "没有账户？",
    "login.register": "注册",
    "login.secureConnection": "安全连接",
    "login.showPassword": "显示密码",
    "login.hidePassword": "隐藏密码",
    
    // Success/Error messages
    "login.success": "登录成功！您可以关闭此标签页。",
    "login.errorEmpty": "请填写所有字段",
    "login.errorEmail": "请输入有效的电子邮件",
    "login.errorPasswordShort": "密码至少需要6个字符",
    "login.errorPasswordLong": "密码太长",
    "login.errorTimeout": "连接超时。请检查网络连接。",
    "login.errorGeneric": "发生错误",
    "login.errorRateLimit": "尝试次数过多。请等待 {seconds} 秒。",
    "login.errorServer": "服务器响应无效",
    "login.errorLogin": "登录失败"
  }
};

// Current language
let currentLang = localStorage.getItem('wbcalc_lang') || 'ru';

// Get translation
function t(key, params = {}) {
  const lang = translations[currentLang] || translations.ru;
  let text = lang[key] || translations.ru[key] || key;
  
  // Replace params like {seconds}
  Object.keys(params).forEach(param => {
    text = text.replace(`{${param}}`, params[param]);
  });
  
  return text;
}

// Set language and update UI
function setLanguage(lang) {
  if (!translations[lang]) lang = 'ru';
  currentLang = lang;
  localStorage.setItem('wbcalc_lang', lang);
  updateUI();
  updateLanguageSelector();
}

// Update all translatable elements
function updateUI() {
  // Update title
  document.title = t('login.title');
  
  // Update elements with data-i18n attribute
  document.querySelectorAll('[data-i18n]').forEach(el => {
    const key = el.getAttribute('data-i18n');
    el.textContent = t(key);
  });
  
  // Update placeholders
  document.querySelectorAll('[data-i18n-placeholder]').forEach(el => {
    const key = el.getAttribute('data-i18n-placeholder');
    el.placeholder = t(key);
  });
  
  // Update aria-labels
  document.querySelectorAll('[data-i18n-aria]').forEach(el => {
    const key = el.getAttribute('data-i18n-aria');
    el.setAttribute('aria-label', t(key));
  });
}

// Update language selector buttons
function updateLanguageSelector() {
  document.querySelectorAll('.lang-btn').forEach(btn => {
    const lang = btn.getAttribute('data-lang');
    if (lang === currentLang) {
      btn.classList.add('active');
    } else {
      btn.classList.remove('active');
    }
  });
}

// Initialize on load
document.addEventListener('DOMContentLoaded', () => {
  updateUI();
  updateLanguageSelector();
  
  // Add click handlers to language buttons
  document.querySelectorAll('.lang-btn').forEach(btn => {
    btn.addEventListener('click', () => {
      const lang = btn.getAttribute('data-lang');
      setLanguage(lang);
    });
  });
});
