// Content script - работает на странице товара Wildberries

// Извлекаем артикул из URL или со страницы
function extractArticle() {
  // Вариант 1: из URL (например, /catalog/164206670/detail.aspx)
  const urlMatch = window.location.pathname.match(/\/catalog\/(\d+)\//);
  if (urlMatch) {
    return urlMatch[1];
  }
  
  // Вариант 2: из data-атрибутов или мета-тегов
  const articleMeta = document.querySelector('meta[property="og:url"]');
  if (articleMeta) {
    const match = articleMeta.content.match(/\/catalog\/(\d+)\//);
    if (match) return match[1];
  }
  
  // Вариант 3: из текста на странице (если есть "Артикул: 123456")
  const articleText = document.body.innerText.match(/Артикул:\s*(\d+)/i);
  if (articleText) {
    return articleText[1];
  }
  
  return null;
}

// Слушаем сообщения от popup
chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
  if (request.action === 'getArticle') {
    const article = extractArticle();
    sendResponse({ article });
  }
  return true;
});

// Можно добавить визуальный индикатор что расширение активно
function addIndicator() {
  const indicator = document.createElement('div');
  indicator.id = 'wb-calculator-indicator';
  indicator.innerHTML = '🧮 WB Calculator активен';
  indicator.style.cssText = `
    position: fixed;
    bottom: 20px;
    right: 20px;
    background: #6366f1;
    color: white;
    padding: 10px 15px;
    border-radius: 8px;
    font-size: 14px;
    z-index: 10000;
    box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    cursor: pointer;
  `;
  
  indicator.addEventListener('click', () => {
    // Открываем popup расширения при клике на индикатор
    chrome.runtime.sendMessage({ action: 'openPopup' });
  });
  
  document.body.appendChild(indicator);
  
  // Скрываем через 3 секунды
  setTimeout(() => {
    indicator.style.opacity = '0';
    indicator.style.transition = 'opacity 0.5s';
    setTimeout(() => indicator.remove(), 500);
  }, 3000);
}

// Добавляем индикатор при загрузке страницы товара
if (extractArticle()) {
  addIndicator();
}
